include <BOSL2/std.scad>

module_padding = 0.3;
module_rounding = 0.3;
edge_padding = 4;
edge_rounding = 4;
resolution = 10;
thickness = 0.5;

// QR code data for "https://bit.ly/wbrick" (25 x 25)
// Generated by Altair's OpenSCAD QR Code Generator
// https://ridercz.github.io/OpenSCAD-QR/
qr_data = [[1,1,1,1,1,1,1,0,1,0,0,1,1,1,0,0,0,0,1,1,1,1,1,1,1],
           [1,0,0,0,0,0,1,0,0,1,1,0,0,0,1,0,0,0,1,0,0,0,0,0,1],
           [1,0,1,1,1,0,1,0,0,0,1,0,1,1,0,0,1,0,1,0,1,1,1,0,1],
           [1,0,1,1,1,0,1,0,0,0,0,0,1,1,0,0,1,0,1,0,1,1,1,0,1],
           [1,0,1,1,1,0,1,0,0,1,0,1,0,1,1,0,1,0,1,0,1,1,1,0,1],
           [1,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,1],
           [1,1,1,1,1,1,1,0,1,0,1,0,1,0,1,0,1,0,1,1,1,1,1,1,1],
           [0,0,0,0,0,0,0,0,1,0,1,1,0,1,0,1,1,0,0,0,0,0,0,0,0],
           [1,1,0,1,1,0,1,0,0,1,1,1,0,0,1,1,0,0,1,0,0,0,0,0,1],
           [1,1,1,0,1,1,0,1,1,1,0,0,1,0,1,1,0,0,0,1,1,1,1,1,0],
           [0,0,1,1,0,0,1,0,0,0,1,1,0,1,1,1,1,1,0,0,0,1,0,0,1],
           [1,0,0,0,1,1,0,1,1,1,1,1,1,0,1,1,0,0,1,0,0,1,1,1,1],
           [0,1,0,0,1,0,1,0,1,1,0,1,1,0,0,0,1,0,1,1,0,0,0,0,1],
           [1,0,1,0,0,1,0,0,1,0,0,0,0,0,1,1,0,1,0,0,1,0,0,1,0],
           [1,1,0,0,1,1,1,1,0,1,0,1,1,0,0,1,0,1,1,0,1,1,1,1,1],
           [1,0,1,1,0,0,0,0,1,0,1,1,0,0,0,0,1,0,1,1,0,1,1,0,1],
           [1,0,1,1,0,0,1,1,0,0,0,0,0,0,1,0,1,1,1,1,1,0,1,1,0],
           [0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,1,1,0,0,0,1,0,1,1,0],
           [1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,0,1,0,1,0,1,0,0,0,1],
           [1,0,0,0,0,0,1,0,0,1,1,0,1,0,1,1,1,0,0,0,1,0,0,1,1],
           [1,0,1,1,1,0,1,0,1,1,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1],
           [1,0,1,1,1,0,1,0,1,1,0,0,0,0,1,0,1,0,1,0,0,0,0,1,1],
           [1,0,1,1,1,0,1,0,0,1,0,0,1,0,1,0,1,1,0,0,1,1,1,1,1],
           [1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,1,1,0,1,1,1],
           [1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,0,1,1,0,0,0,1,0,0,1]];

// Render QR code with default settings (module 1x1x1)
difference(){
translate([-edge_padding/2,-edge_padding/2,0]) cuboid([len(qr_data)+edge_padding,len(qr_data)+edge_padding, thickness],anchor=BOTTOM+LEFT+FRONT,rounding=edge_rounding, edges=[LEFT+FRONT,LEFT+BACK,RIGHT+FRONT,RIGHT+BACK],$fn=resolution*25);
qr_render(qr_data,height=thickness);
}
// QR code rendering method
module qr_render(data, module_size = 1, height = 1) {
    maxmod = len(data) - 1;
    union() {
        for(r = [0 : maxmod]) {
            for(c = [0 : maxmod]) {
                if(data[r][c] == 1){
                    xo = c * module_size;
                    yo = (maxmod - r) * module_size;
                    translate([xo+module_padding/2, yo+module_padding/2, 0]) cuboid([module_size-module_padding, module_size-module_padding, height],anchor=BOTTOM+LEFT+FRONT,rounding=module_rounding, edges=[LEFT+FRONT,LEFT+BACK,RIGHT+FRONT,RIGHT+BACK],$fn=resolution);
                }
            }
        }
    }
}